#!/usr/bin/perl
use strict ;

require 'lib/jte.pl' ;


# function の使用例

sub page_head {
	my $jte = shift ;
	my $element = shift ;
	my $data = shift ;
	
	my $html = '' ;
	$html .= "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n" ;
	$html .= "<title>" . $jte->htmlspecialchars( 'JTE サンプル 実行後(Perl)' ) . "</title>\n" ;
	
	# innerHTML
	
	while ( $element->childNodes->length > 0 ) {
		$element->removeChild( $element->firstChild ) ;
	}
	
	$jte->_parse( $element, \$html ) ;
}

# jte へのデータを準備
# 実際はデータベースなどから設定します。

my $data = {
	'condition'	=> {},
	'value'		=> {},
	'record'	=> {},
	'function'	=> {}
} ;

$data->{ 'condition' }->{ 'case_1' } = 1 ;
$data->{ 'condition' }->{ 'case_2' } = 0 ;

$data->{ 'condition' }->{ 'column_1' } = 1 ;
$data->{ 'condition' }->{ 'column_2' } = 0 ;

$data->{ 'value' }->{ 'template' } = '' ;
$data->{ 'value' }->{ 'text_inner' } = 'innerで内容を書き換えました。<br />複数のエレメントを記述できます。' ;
$data->{ 'value' }->{ 'text_outer' } = 'outerでタグを書き換えました。<br />複数のエレメントを記述できます。<br />' ;

$data->{ 'value' }->{ 'copyright_url' } = 'http://www.japro.net' ;
$data->{ 'value' }->{ 'copyright_name' } = 'JAPRO(C)' ;

$data->{ 'record' }->{ 'list' } = [] ;

push( @{ $data->{ 'record' }->{ 'list' } }, { 'value' => {
	'url'		=> 'http://www.google.co.jp/',
	'name'		=> 'Google'
} } ) ;

push( @{ $data->{ 'record' }->{ 'list' } }, { 'value' => {
	'url'		=> 'http://www.yahoo.co.jp/',
	'name'		=> 'Yahoo! Japan'
} } ) ;

$data->{ 'function' }->{ 'head' } = \&page_head ;


# テンプレートにデータを適用して表示

print( "Content-Type: text/html; charset=UTF-8\n\n" ) ;

my $jte = new JTE() ;

$jte->execute( 'template/default.html', $data ) ;

exit ;
